﻿using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.Context.Interface;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService.Mappers
{
    public class MapAuthorizedOfficialToCrm : MapperRelatedBase
    {
        public MapAuthorizedOfficialToCrm(IPpmsContextHelper ppmsContextHelper, IPpmsHelper ppmsHelper) 
            : base(ppmsContextHelper, ppmsHelper)
        {}

        public async Task<ppms_organizationauthorizedofficial> MapInsert(OrganizationAuthorizedOfficial official, Account provider)
        {
            // map provider
            var entity = new ppms_organizationauthorizedofficial
            {
                Id = Guid.NewGuid(),
                ppms_name = official.OfficialName,
                ppms_credential = official.OfficialCredential,
                ppms_titleorposition = official.TitleOrPosition,
                ppms_phone = official.PhoneNumber
            };

            await Task.Run(() => {});

            return entity;
        }

        public async Task<ppms_organizationauthorizedofficial> MapUpdate(OrganizationAuthorizedOfficial entity, Account provider)
        {
            // get entity
            var crmEntity = GetCrmEntity(provider, entity.OfficialName);

            // matching account not found
            if (crmEntity == null)
            {
                return await MapInsert(entity, provider);
            }

            var newEntity = new ppms_organizationauthorizedofficial() { Id = crmEntity.Id };

            // Map fields
            if (IsChanged(entity.OfficialName, newEntity.ppms_name))
                newEntity.ppms_name = entity.OfficialName;

            if (IsChanged(entity.OfficialCredential, newEntity.ppms_credential))
                newEntity.ppms_credential = entity.OfficialCredential;

            if (IsChanged(entity.TitleOrPosition, newEntity.ppms_titleorposition))
                newEntity.ppms_titleorposition = entity.TitleOrPosition;

            if (IsChanged(entity.PhoneNumber, newEntity.ppms_phone))
                newEntity.ppms_phone = entity.PhoneNumber;

            return newEntity;
        }

        private static ppms_organizationauthorizedofficial GetCrmEntity(Account provider, string id)
        {
            var list = provider.ppms_account_organizationauthorizedofficial;
            if (list == null) return null;

            var ppmsOrganizationauthorizedofficials = list as ppms_organizationauthorizedofficial[] ?? list.ToArray();

            return ppmsOrganizationauthorizedofficials.Any() ? ppmsOrganizationauthorizedofficials.FirstOrDefault(x => x.ppms_name == id) : null;
        }

        private static OrganizationAuthorizedOfficial ConvertEntity<T>(T entity)
        {
            return (OrganizationAuthorizedOfficial)Convert.ChangeType(entity, typeof(OrganizationAuthorizedOfficial));
        }

        public override async Task<Entity> MapUpdate<T>(T entity, Entity parent)
        {
            return await MapUpdate(ConvertEntity(entity), (Account)parent);
        }

        public override async Task<Entity> MapInsert<T>(T entity, Entity parent)
        {
            return await MapInsert(ConvertEntity(entity), (Account)parent);
        }

        public override void AddChildrenToProvider(IList<Entity> entities, Entity parent)
        {
            if (IsWithinContext) AssociateRelatedEntities(parent, entities, "ppms_account_organizationauthorizedofficial");
            else
            {
                if (entities != null && entities.Count > 0)
                {
                    var account = (Account)parent;
                    if (account != null)
                        account.ppms_account_organizationauthorizedofficial = ConvertEntityList<ppms_organizationauthorizedofficial>(entities);
                }
            }
        }

        public override IEnumerable<SetStateRequest> MapDelete<T>(IList<T> entities, Entity parent)
        {
            if (entities == null || !entities.Any()) return null;

            // Check provider
            var provider = (Account)parent;
            if (provider == null) return null;

            var list = new List<T>();

            // Map schema entities for delete
            foreach (var item in entities)
            {
                var entity = ConvertEntity(item);
                var entity1 = entity;
                var matches = provider.ppms_account_organizationauthorizedofficial.Where(p => p.ppms_name == entity1.OfficialName);
                list.AddRange((IEnumerable<T>)matches);
            }

            return EntityDelete((IEnumerable<ppms_organizationauthorizedofficial>)list);
        }
    }
}